use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear

gen big6 = 0 
replace big6 = 1 if name == "baml" | name == "ms" | name == "jpm" | name == "gs" | name == "wf" | name == "citi"

keep if big6 == 1
br if ptb == . & year >= 2000

gen date_use = date
format date_use %tdCCYY

egen id = group(name)
tsset id date_use 

drop if ptb == . 

tssmooth ma ptb_ma = ptb, window(90)

label var ptb_ma "Price-to-Book Ratio"



gen recession =  . 
replace recession = 1 if (year == 2008 | year == 2009)
egen ptb_ma_max = max(ptb_ma) if name == "baml"

egen ptb_ma_max_baml = max(ptb_ma) if (name == "baml" & year > 1999)
label var ptb_ma_max_baml "" 

egen ptb_ma_max_citi = max(ptb_ma) if (name == "citi" & year > 1999)
label var ptb_ma_max_citi ""

egen ptb_ma_max_gs = max(ptb_ma) if (name == "gs" & year > 1999)
label var ptb_ma_max_gs ""

egen ptb_ma_max_jpm = max(ptb_ma) if (name == "jpm" & year > 1999)
label var ptb_ma_max_jpm "" 

egen ptb_ma_max_wf = max(ptb_ma) if (name == "wf" & year > 1999)
label var ptb_ma_max_wf "" 


egen ptb_ma_max_ms = max(ptb_ma) if (name == "ms" & year > 1999)
label var ptb_ma_max_ms "" 

cd "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\"


twoway (bar ptb_ma_max date_use if (recession == 1 & year >1999 & name == "baml"), color(gs12)) (line ptb_ma date_use)  if (name == "baml")

graph twoway (bar ptb_ma_max_baml date_use if (recession == 1 & year >1999 & name == "baml"), color(gs12) leg(off)) (line ptb_ma date_use if (name == "baml" & year> 1999)), xtitle("") title("Price-to-Book for Bank of America Over Time") xlabel(,labsize(small)) leg(off) 

graph export baml_ptb.png, replace 

graph twoway (bar ptb_ma_max_citi date_use if (recession == 1 & year >1999 & name == "citi"), color(gs12) leg(off)) (line ptb_ma date_use if (name == "citi" & year> 1999)), xtitle("") title("Price-to-Book for Citigroup Over Time") xlabel(,labsize(small)) leg(off)

graph export citi_ptb.png, replace 

graph twoway (bar ptb_ma_max_ms date_use if (recession == 1 & year >1999 & name == "ms"), color(gs12) leg(off)) (line ptb_ma date_use if (name == "ms" & year> 1999)), xtitle("") title("Price-to-Book for Morgan Stanley Over Time") xlabel(,labsize(small)) leg(off)

graph export ms_ptb.png, replace 

graph twoway (bar ptb_ma_max_gs date_use if (recession == 1 & year >1999 & name == "gs"), color(gs12) leg(off)) (line ptb_ma date_use if (name == "gs" & year> 1999)), xtitle("") title("Price-to-Book for Goldman Sachs Over Time") xlabel(,labsize(small)) leg(off)

graph export gs_ptb.png, replace 

graph twoway (bar ptb_ma_max_wf date_use if (recession == 1 & year >1999 & name == "wf"), color(gs12) leg(off)) (line ptb_ma date_use if (name == "wf" & year> 1999)), xtitle("") title("Price-to-Book for Wells Fargo Over Time") xlabel(,labsize(small)) leg(off)

graph export wf_ptb.png, replace 

graph twoway (bar ptb_ma_max_jpm date_use if (recession == 1 & year >1999 & name == "jpm"), color(gs12) leg(off)) (line ptb_ma date_use if (name == "jpm" & year> 1999)), xtitle("") title("Price-to-Book for JP Morgan Over Time") xlabel(,labsize(small)) leg(off)

graph export jpm_ptb.png, replace 




